/*
 * Decompiled with CFR 0.152.
 */
package net.montoyo.mcef.remote;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;

public final class Mirror {
    public static final int FLAG_SECURE = 1;
    public static final int FLAG_FORCED = 4;
    private final String name;
    private final String url;
    private final int flags;

    public Mirror(String name, String url, int flags) {
        this.name = name;
        this.url = url;
        this.flags = flags;
    }

    public String getName() {
        return this.name;
    }

    public String getURL() {
        return this.url;
    }

    public int getFlags() {
        return this.flags;
    }

    public boolean isSecure() {
        return (this.flags & 1) != 0;
    }

    public boolean isForced() {
        return (this.flags & 4) != 0;
    }

    public String getInformationString() {
        return this.isForced() ? "Mirror location forced by user to: " + this.url : "Selected mirror: " + this.name;
    }

    public URLConnection getResource(String name) throws MalformedURLException, IOException {
        if (this.url.startsWith("file://")) {
            return new URL(this.url + "/" + name).openConnection();
        }
        HttpURLConnection ret = (HttpURLConnection)new URL(this.url + "/" + name).openConnection();
        ret.setConnectTimeout(30000);
        ret.setReadTimeout(15000);
        ret.setRequestProperty("User-Agent", "MCEF");
        return ret;
    }
}

